#!/bin/bash

# Define the swap file location and size
SWAPFILE="/swapfile"
SWAPSIZE="64G"

# Check if the script is being run as root
if [ "$(id -u)" -ne 0 ]; then
    echo "This script must be run as root"
    exit 1
fi

# Ensure util-linux is installed for mkswap and swapon commands
apt-get update
apt-get install -y util-linux

# Create the swap file with the defined size
fallocate -l $SWAPSIZE $SWAPFILE

# Set the correct permissions for the swap file
chmod 600 $SWAPFILE

# Set up the swap area
/sbin/mkswap $SWAPFILE

# Enable the swap file
/sbin/swapon $SWAPFILE

# Add the swap file to /etc/fstab for automatic mounting at boot
echo "$SWAPFILE none swap sw 0 0" >> /etc/fstab

# Verify the swap file is active
/sbin/swapon --show

# Confirm the swap file entry in /etc/fstab
grep swapfile /etc/fstab

echo "Swap file created and activated successfully."
