# Windows 10/11 Debloat Script for Microsoft 365 Workstations
# Run as Administrator

# Create a restore point
Enable-ComputerRestore -Drive "C:\"
Checkpoint-Computer -Description "Before Debloat" -RestorePointType "MODIFY_SETTINGS"

# Function to remove Windows Apps
Function Remove-WindowsApps {
    $apps = @(
        # Games & Xbox
        "Microsoft.Xbox.TCUI"
        "Microsoft.XboxApp"
        "Microsoft.XboxGameOverlay"
        "Microsoft.XboxGamingOverlay"
        "Microsoft.XboxIdentityProvider"
        "Microsoft.XboxSpeechToTextOverlay"
        "Microsoft.GamingApp"
        "Microsoft.GamingServices"
        "Microsoft.MicrosoftSolitaireCollection"
        
        # Entertainment
        "Microsoft.ZuneMusic"
        "Microsoft.ZuneVideo"
        "Microsoft.WindowsMixedReality.Portal"
        "Microsoft.BingNews"
        "Microsoft.GetHelp"
        "Microsoft.Getstarted"
        "Microsoft.WindowsFeedbackHub"
        
        # Third-party bloatware
        "king.com.CandyCrushSaga"
        "king.com.FarmHeroesSaga"
        "*Spotify*"
        "*Disney*"
        "*Netflix*"
        "*Hulu*"
        
        # Other unnecessary apps
        "Microsoft.3DBuilder"
        "Microsoft.Microsoft3DViewer"
        "Microsoft.MixedReality.Portal"
        "Microsoft.SkypeApp"
        "Microsoft.WindowsAlarms"
        "Microsoft.WindowsCamera"
        "Microsoft.WindowsMaps"
        "Microsoft.WindowsSoundRecorder"
        "Microsoft.YourPhone"
        "Microsoft.MicrosoftOfficeHub" # Not needed with M365 installed
        "Microsoft.People"
        "Microsoft.Windows.Photos"
        "Microsoft.WindowsCalculator"
    )

    ForEach ($app in $apps) {
        Write-Host "Removing: $app"
        Get-AppxPackage -Name $app -AllUsers | Remove-AppxPackage -ErrorAction SilentlyContinue
        Get-AppxProvisionedPackage -Online | Where-Object DisplayName -like $app | Remove-AppxProvisionedPackage -Online -ErrorAction SilentlyContinue
    }
}

# Function to disable unnecessary services
Function Disable-UnwantedServices {
    $services = @(
        "XblAuthManager"          # Xbox Live Auth Manager
        "XblGameSave"            # Xbox Live Game Save
        "XboxNetApiSvc"          # Xbox Live Networking
        "WMPNetworkSvc"          # Windows Media Player Network
        "RetailDemo"             # Retail Demo Service
        "WerSvc"                 # Windows Error Reporting
        "wisvc"                  # Windows Insider Service
        "lfsvc"                  # Geolocation Service
        "MapsBroker"             # Downloaded Maps Manager
        "WSearch"                # Windows Search (can be re-enabled if needed)
        "DiagTrack"              # Connected User Experiences and Telemetry
        "SysMain"                # Superfetch
        "iphlpsvc"               # IP Helper (IPv6 components)
        "WbioSrvc"               # Windows Biometric Service
        "FontCache"              # Windows Font Cache Service
        "TabletInputService"     # Touch Keyboard and Handwriting Panel Service
    )

    ForEach ($service in $services) {
        Write-Host "Disabling service: $service"
        Set-Service -Name $service -StartupType Disabled -ErrorAction SilentlyContinue
        Stop-Service -Name $service -Force -ErrorAction SilentlyContinue
    }
}

# Function to disable telemetry and other unnecessary features
Function Disable-Telemetry {
    # Disable telemetry
    Set-ItemProperty -Path "HKLM:\SOFTWARE\Policies\Microsoft\Windows\DataCollection" -Name "AllowTelemetry" -Type DWord -Value 0
    
    # Disable Cortana
    Set-ItemProperty -Path "HKLM:\SOFTWARE\Policies\Microsoft\Windows\Windows Search" -Name "AllowCortana" -Type DWord -Value 0
    
    # Disable Consumer Features
    Set-ItemProperty -Path "HKLM:\SOFTWARE\Policies\Microsoft\Windows\CloudContent" -Name "DisableWindowsConsumerFeatures" -Type DWord -Value 1
    
    # Disable Suggest Apps
    Set-ItemProperty -Path "HKCU:\SOFTWARE\Microsoft\Windows\CurrentVersion\ContentDeliveryManager" -Name "SubscribedContent-338388Enabled" -Type DWord -Value 0
    
    # Disable Advertising ID
    Set-ItemProperty -Path "HKCU:\SOFTWARE\Microsoft\Windows\CurrentVersion\AdvertisingInfo" -Name "Enabled" -Type DWord -Value 0
}

# Function to optimize Windows performance
Function Optimize-WindowsPerformance {
    Write-Host "Optimizing system performance..."

    # Disable visual effects
    Set-ItemProperty -Path "HKCU:\Software\Microsoft\Windows\CurrentVersion\Explorer\VisualEffects" -Name "VisualFXSetting" -Type DWord -Value 2
    
    # Disable animations
    Set-ItemProperty -Path "HKCU:\Control Panel\Desktop\WindowMetrics" -Name "MinAnimate" -Type String -Value "0"
    
    # Optimize for performance
    $path = "HKCU:\Software\Microsoft\Windows\CurrentVersion\Explorer\VisualEffects\AnimateMinMax"
    If (!(Test-Path $path)) {
        New-Item -Path $path -Force | Out-Null
    }
    Set-ItemProperty -Path $path -Name "Enabled" -Type DWord -Value 0
    
    # Disable Transparency
    Set-ItemProperty -Path "HKCU:\Software\Microsoft\Windows\CurrentVersion\Themes\Personalize" -Name "EnableTransparency" -Type DWord -Value 0
    
    # Set virtual memory (page file)
    $computersys = Get-WmiObject Win32_ComputerSystem -EnableAllPrivileges
    $computersys.AutomaticManagedPagefile = $False
    $computersys.Put()
    $pagefile = Get-WmiObject -Query "Select * From Win32_PageFileSetting Where Name like '%pagefile.sys'"
    $pagefile.InitialSize = 4096  # 4GB initial size
    $pagefile.MaximumSize = 8192  # 8GB maximum size
    $pagefile.Put()

    # Disable Memory Compression
    Disable-MMAgent -mc
    
    # Disable Fast Startup
    Set-ItemProperty -Path "HKLM:\SYSTEM\CurrentControlSet\Control\Session Manager\Power" -Name "HiberbootEnabled" -Type DWord -Value 0
}

# Function to disable hibernation and optimize power settings
Function Optimize-PowerSettings {
    Write-Host "Optimizing power settings..."

    # Disable hibernation
    powercfg /hibernate off
    
    # Set power plan to high performance
    powercfg /setactive 8c5e7fda-e8bf-4a96-9a85-a6e23a8c635c
    
    # Disable sleep
    powercfg /change standby-timeout-ac 0
    powercfg /change standby-timeout-dc 0
    
    # Disable monitor timeout
    powercfg /change monitor-timeout-ac 0
    powercfg /change monitor-timeout-dc 0
    
    # Disable disk timeout
    powercfg /change disk-timeout-ac 0
    powercfg /change disk-timeout-dc 0
    
    # Disable hybrid sleep
    powercfg /change hibernate-timeout-ac 0
    powercfg /change hibernate-timeout-dc 0
}

# Function to optimize network settings
Function Optimize-NetworkSettings {
    Write-Host "Optimizing network settings..."

    # Disable IPv6
    Disable-NetAdapterBinding -Name "*" -ComponentID "ms_tcpip6"
    
    # Set DNS Client service to automatic
    Set-Service "Dnscache" -StartupType Automatic
    
    # Disable NetBIOS over TCP/IP
    $adapters = Get-WmiObject Win32_NetworkAdapterConfiguration
    foreach($adapter in $adapters) {
        $adapter.SetTcpipNetbios(2)
    }
    
    # Optimize TCP/IP settings
    netsh int tcp set global autotuninglevel=normal
    netsh int tcp set global chimney=enabled
    netsh int tcp set global dca=enabled
    netsh int tcp set global netdma=enabled
}

# Main execution
Write-Host "Starting Windows Debloat and Optimization Script..."
Write-Host "Creating System Restore Point..."

# Execute functions
Remove-WindowsApps
Disable-UnwantedServices
Disable-Telemetry
Optimize-WindowsPerformance
Optimize-PowerSettings
Optimize-NetworkSettings

# Clear temp files
Remove-Item -Path "C:\Windows\Temp\*" -Recurse -Force -ErrorAction SilentlyContinue
Remove-Item -Path "$env:TEMP\*" -Recurse -Force -ErrorAction SilentlyContinue

Write-Host "Cleanup and optimization complete. Please restart your computer for changes to take effect."

# Optional: Force restart
# Restart-Computer -Force