// Add a custom checkout fields for QRh, Tipo Cliente & NIF/CIF/NIE/DNI and save them to the database as META data

/**
 * Add a 'Tipo cliente' dropdown field to the WooCommerce checkout page with specific options
 */
add_filter('woocommerce_checkout_fields', 'custom_add_tipo_cliente_dropdown');
function custom_add_tipo_cliente_dropdown($fields) {
    $fields['billing']['billing_tipo_cliente'] = array(
        'type'     => 'select',
        'label'    => __('Tipo cliente', 'woocommerce'),
        'required' => true,
        'class'    => array('form-row-wide'),
        'options'  => array(
            ''                                 => __('Elige un tipo de cliente', 'woocommerce'),
            'estudiante'                       => __('Estudiante', 'woocommerce'),
            'salon_de_belleza'                 => __('Salón de belleza', 'woocommerce'),
            'esteticista'                      => __('Esteticista', 'woocommerce'),
            'maquillador'                      => __('Maquillador', 'woocommerce'),
            'salon_peluqueria_barberia'        => __('Salón Peluquería / Barbería', 'woocommerce'),
            'peluquero_barbero_autonomo'       => __('Peluquero / Barbero autónomo', 'woocommerce'),
            'peluquero_barbero_empleado'       => __('Peluquero / Barbero empleado', 'woocommerce'),
        ),
        'priority' => 22,
    );

    return $fields;
}

/**
 * Process and validate the 'Tipo cliente' dropdown field
 */
add_action('woocommerce_checkout_process', 'custom_validate_tipo_cliente_field');
function custom_validate_tipo_cliente_field() {
    if (!isset($_POST['billing_tipo_cliente']) || empty($_POST['billing_tipo_cliente'])) {
        wc_add_notice(__('Elige un tipo de cliente por favor.', 'woocommerce'), 'error');
    }
}

// For a WooCommerce registration form, use the following instead:
// add_action('woocommerce_register_form', 'custom_add_user_type_registration_dropdown');

function custom_save_user_type( $user_id ) {
    if ( ! empty( $_POST['user_type'] ) ) {
        update_user_meta( $user_id, 'user_type', sanitize_text_field( $_POST['user_type'] ) );
    }
}
// For a generic WordPress registration
//add_action( 'user_register', 'custom_save_user_type' );
// For a WooCommerce-specific registration, use the following instead:
add_action( 'woocommerce_created_customer', 'custom_save_user_type' );

/**
 * Add a CIF/NIF field to the WooCommerce checkout page
 */
add_filter('woocommerce_checkout_fields', 'custom_add_checkout_fields');
function custom_add_checkout_fields($fields) {
    $fields['billing']['billing_nif'] = array(
        'label'        => __('CIF/NIF/DNI/NIE', 'woocommerce'),
        'placeholder'  => _x('CIF/NIF/DNI/NIE', 'placeholder', 'woocommerce'),
        'required'     => true,
        'class'        => array('form-row-wide'),
        'clear'        => true,
        'priority'     => 21, // Adjust the priority to position just after the last name
    );

    return $fields;
}

/**
 * Process and validate the CIF/NIF field
 */
add_action('woocommerce_checkout_process', 'custom_validate_checkout_field_process');
function custom_validate_checkout_field_process() {
    if (!$_POST['billing_nif'])
        wc_add_notice(__('Please enter your CIF/NIF.'), 'error');
}

/**
 * Save the 'Tipo cliente' field with the order and user meta
 */
add_action('woocommerce_checkout_update_order_meta', 'custom_checkout_field_update_order_meta_tipo_cliente');
function custom_checkout_field_update_order_meta_tipo_cliente($order_id) {
    if (!empty($_POST['billing_tipo_cliente'])) {
        // Save to order meta
        update_post_meta($order_id, '_billing_tipo_cliente', sanitize_text_field($_POST['billing_tipo_cliente']));

        // Get the customer user ID
        $customer_user_id = get_post_meta($order_id, '_customer_user', true);
        if ($customer_user_id) {
            // Save to user meta as well
            update_user_meta($customer_user_id, 'billing_tipo_cliente', sanitize_text_field($_POST['billing_tipo_cliente']));
        }
    }
}

add_filter( 'woocommerce_checkout_get_value', 'custom_checkout_field_default_value', 10, 2 );
function custom_checkout_field_default_value( $value, $input ) {
    $current_user = wp_get_current_user();

    if ( is_user_logged_in() && $input == 'billing_tipo_cliente' ) {
        $user_tipo_cliente = get_user_meta( $current_user->ID, 'billing_tipo_cliente', true );
        if ( !empty($user_tipo_cliente) ) {
            $value = $user_tipo_cliente;
        }
    }

    return $value;
}
