add_action('woocommerce_product_query', 'hide_products_without_image_and_zero_stock');

function hide_products_without_image_and_zero_stock($q) {
    $meta_query = $q->get('meta_query');

    // Condition to check for products with an image
    $meta_query[] = array(
        'key' => '_thumbnail_id',
        'compare' => 'EXISTS' // Ensures the product has an associated image
    );

    // Condition to check for products with stock quantity higher than 0
    $meta_query[] = array(
        'key' => '_stock',
        'value' => 0,
        'compare' => '>' // Ensures the product stock is greater than 0
    );

    // Set the modified meta query back on the query object
    $q->set('meta_query', $meta_query);
}
