#!/bin/bash

find . -maxdepth 1 -name "*.csv" | while read file; do
    filename=$(basename "$file")
    if [[ "$filename" == *"_"* ]]; then
        # File has at least one underscore
        main_category=$(echo "$filename" | cut -d'_' -f1)
    else
        # File has no underscore, it is itself a main category
        main_category="${filename%.csv}"
    fi
    mkdir -p "$main_category"
    mv "$file" "$main_category/"
done

echo "File organization complete!"