#!/bin/bash

# Define swapfile size and path
SWAPFILE_PATH="/var/lib/vz/swapfile"
SWAPFILE_SIZE="64G"

# Create the swapfile with the specified size
fallocate -l $SWAPFILE_SIZE $SWAPFILE_PATH

# Set the correct permissions
chmod 600 $SWAPFILE_PATH

# Set up the swap space
mkswap $SWAPFILE_PATH

# Enable the swapfile
swapon $SWAPFILE_PATH

# Add the swapfile entry to /etc/fstab
echo "$SWAPFILE_PATH none swap sw 0 0" >> /etc/fstab

# Verify the swap is active
swapon --show

echo "64GB swapfile created and mounted successfully."
