// for QRh

function add_order_counts_to_admin_bar( $wp_admin_bar ) {
    if ( ! current_user_can( 'manage_woocommerce' ) ) {
        return;
    }

    // Query total orders
    $args_total = array(
        'limit'        => -1,
        'return'       => 'ids',
        'status'       => array('any')
    );
    $total_orders = wc_get_orders( $args_total );
    $total_count = count( $total_orders );

    // Query processing orders
    $args_processing = array(
        'limit'        => -1,
        'return'       => 'ids',
        'status'       => array('processing')
    );
    $processing_orders = wc_get_orders( $args_processing );
    $processing_count = count( $processing_orders );

    // Add total orders node
    $wp_admin_bar->add_node( array(
        'id'    => 'total_orders',
        'title' => 'Total Orders: ' . $total_count,
        'href'  => admin_url('edit.php?post_type=shop_order'),
    ));

    // Add processing orders node
    $wp_admin_bar->add_node( array(
        'id'    => 'processing_orders',
        'title' => 'Processing Orders: ' . $processing_count,
        'href'  => admin_url('edit.php?post_type=shop_order&post_status=wc-processing'),
    ));
}

add_action( 'admin_bar_menu', 'add_order_counts_to_admin_bar', 100 );
