// Original Order.php B2C API

<?php

namespace Encodigoweb\Woocommerce\Handlers;

use Encodigoweb\Woocommerce\Repository\OrderRepository;
use Exception;
use WC_Customer;

final class Order extends Handler
{
    public function __construct()
    {
        parent::__construct();

        $this->log_context = ['source' => 'Order'];

        $this->apis = ['order'];

        $this->order_repository = new OrderRepository();
    }

    public function process()
    {
        $this->logger->info('Inicio sincronización pedidos', $this->log_context);

        $posts = $this->order_repository->getOrders();

        if (!empty($posts))
        {
            foreach ($posts as $post)
            {
                $response = $this->sendOrder($post);
            }
        }
        else
        {
            $this->logger->info('No hay pedidos para procesar', $this->log_context);

            echo 'No hay pedidos para procesar';
        }

        $this->logger->info('Fin sincronización pedidos', $this->log_context);

        echo 'Proceso Terminado';
    }

    public function sendOrder($post)
    {
        $xml = $this->generateXml($post);

        $api_config = $this->config['apis'][$this->apis[0]];

        $api = new Api($api_config);

        $result = $api->callApi($xml);

        if ($result['response'] === true){
            $this->order_repository->insertOrder($post->ID);

            $this->logger->info('Pedido '.$post->ID.' enviado correctamente', $this->log_context);
        }else{
            $this->logger->error('Pedido '.$post->ID.' '.$result['msg'], $this->log_context);
        }
    }

    public function generateXml($post)
    {
        $order = wc_get_order($post->ID);


        $items = $order->get_items();

        $order_lines = '';

        foreach ($items as $item)
        {
            $product = wc_get_product($item->get_product_id());

            $total_line_tax_excl = round($item->get_subtotal(), 2);

            $total_line_tax_incl = round($item->get_subtotal() + $item->get_subtotal_tax(), 2);

            $order_lines .= '<linea>
                                <EcomPedidoId>'.$item->get_order_id().'</EcomPedidoId>
                                <EcomNumLineaId>'.$item->get_id().'</EcomNumLineaId>
                                <ProductoReferencia>'.$product->get_sku().'</ProductoReferencia>
                                <Cantidad>'.$item->get_quantity().'</Cantidad>
                                <Importe>'.$total_line_tax_excl.'</Importe>
                                <ImporteConIva>'.$total_line_tax_incl.'</ImporteConIva>
                            </linea>';
        }

        //$customer = new WC_Customer($order->get_customer_id());

        $dni = get_post_meta($post->ID, '_billing_vat', true);

        $country_billing = $order->get_billing_country();
        $state_billing = $order->get_billing_state();
        $billing_state_name = WC()->countries->get_states( $country_billing )[$state_billing];

        $country_shipping = $order->get_shipping_country();
        $state_shipping = $order->get_shipping_state();
        $shipping_state_name = WC()->countries->get_states( $country_shipping )[$state_shipping];

        $total_tax_excl = round($order->get_subtotal(), 2);

        $total_tax_incl = round($order->get_total(), 2);

        $xml = '<?xml version="1.0"?>
                <pedido>
                    <CabeceraPedido>
                        <EcomPedidoId>'.$order->get_id().'</EcomPedidoId>
                        <CustomerId>'.$order->get_customer_id().'</CustomerId>
                        <CustomerName>'.$order->get_billing_first_name().' '.$order->get_billing_last_name().'</CustomerName>
                        <CustomerCIF>'.$dni.'</CustomerCIF>
                        <CustomerMail>'.$order->get_billing_email().'</CustomerMail>
                        <CustomerTelefono>'.$order->get_billing_phone().'</CustomerTelefono>
                        <CustomerPais>'.$country_billing.'</CustomerPais>
                        <DirFactId>'.$order->get_id().'</DirFactId>
                        <DirFactNombre>'.$order->get_billing_first_name().' '.$order->get_billing_last_name().'</DirFactNombre>
                        <DirFactDireccion>'.$order->get_billing_address_1().' '.$order->get_billing_address_2().'</DirFactDireccion>
                        <DirFactCodigoPostal>'.$order->get_billing_postcode().'</DirFactCodigoPostal>
                        <DirFactPoblacion>'.$order->get_shipping_city().'</DirFactPoblacion>
                        <DirFactProvincia>'.$billing_state_name.'</DirFactProvincia>
                        <DirFactProvinciaCodigo>'.$state_billing.'</DirFactProvinciaCodigo>
                        <DirFactPais>'.$country_billing.'</DirFactPais>
                        <DirFactTelefono>'.$order->get_billing_phone().'</DirFactTelefono>
                        <DirFactMail>'.$order->get_billing_email().'</DirFactMail>
                        <DirFactCIF>'.$dni.'</DirFactCIF>
                        <DirEnvId>'.$order->get_id().'</DirEnvId>
                        <DirEnvNombre>'.$order->get_shipping_first_name().' '.$order->get_shipping_last_name().'</DirEnvNombre>
                        <DirEnvDireccion>'.$order->get_shipping_address_1().' '.$order->get_shipping_address_2().'</DirEnvDireccion>
                        <DirEnvCodigoPostal>'.$order->get_shipping_postcode().'</DirEnvCodigoPostal>
                        <DirEnvPoblacion>'.$order->get_shipping_city().'</DirEnvPoblacion>
                        <DirEnvProvincia>'.$shipping_state_name.'</DirEnvProvincia>
                        <DirEnvProvinciaCodigo>'.$state_shipping.'</DirEnvProvinciaCodigo>
                        <DirEnvPais>'.$country_shipping.'</DirEnvPais>
                        <DirEnvTelefono>'.$order->get_billing_phone().'</DirEnvTelefono>
                        <DirEnvMail>'.$order->get_billing_email().'</DirEnvMail>
                        <DirEnvCIF>'.$dni.'</DirEnvCIF>
                        <EcomTotalGastosEnvio>'.$order->get_shipping_total().'</EcomTotalGastosEnvio>
                        <Importe>'.$total_tax_excl.'</Importe>
                        <ImporteConIva>'.$total_tax_incl.'</ImporteConIva>
                        <MetodoPago>'.$order->get_payment_method().'</MetodoPago>
                    </CabeceraPedido>
                    <LineasPedido>
                        '.$order_lines.'
                    </LineasPedido>
                </pedido>';

        return $xml;
    }
}
