// for easycut.es

add_action('woocommerce_after_checkout_validation', 'restrict_shipping_counties_in_spain', 10, 2);

function restrict_shipping_counties_in_spain($data, $errors) {
    // List of restricted counties
    $restricted_counties = array('CE', 'ML', 'GC', 'TF');

    // Get the shipping country and state from the checkout data
    $shipping_country = isset($data['shipping_country']) ? $data['shipping_country'] : '';
    $shipping_state = isset($data['shipping_state']) ? $data['shipping_state'] : '';

    // Check if the shipping country is Spain and the state is in the restricted list
    if ($shipping_country === 'ES' && in_array($shipping_state, $restricted_counties)) {
        // Add an error to the checkout
        $errors->add('validation', __('El envío a Ceuta, Melilla, Las Palmas y Santa Cruz de Tenerife no está permitido. Por favor, elige una región diferente.', 'woocommerce'));
    }
}

add_action('wp_footer', 'disable_checkout_button_for_restricted_counties_script');

function disable_checkout_button_for_restricted_counties_script() {
    if (is_checkout()) {
        ?>
        <script type="text/javascript">
            jQuery(function($){
                var restrictedCounties = ['CE', 'ML', 'GC', 'TF'];
                var $checkoutForm = $('form.checkout');
                var $placeOrderButton = $('#place_order');

                function validateCounty() {
                    var selectedCountry = $('select#shipping_country').val();
                    var selectedCounty = $('select#shipping_state').val();
                    if (selectedCountry === 'ES' && restrictedCounties.indexOf(selectedCounty) !== -1) {
                        $placeOrderButton.attr('disabled', 'disabled');
                        if ($('.shipping-county-error').length === 0) {
                            $placeOrderButton.before('<div class="woocommerce-error shipping-county-error"><?php _e('El envío a Ceuta, Melilla, Las Palmas y Santa Cruz de Tenerife no está permitido. Por favor, elige una región diferente.', 'woocommerce'); ?></div>');
                        }
                    } else {
                        $placeOrderButton.removeAttr('disabled');
                        $('.shipping-county-error').remove();
                    }
                }

                // Validate on load
                validateCounty();

                // Validate on country and county change
                $('select#shipping_country, select#shipping_state').change(function(){
                    validateCounty();
                });

                // Validate on form submission
                $checkoutForm.on('submit', function(e){
                    validateCounty();
                    if ($placeOrderButton.is(':disabled')) {
                        e.preventDefault();
                        $('html, body').animate({
                            scrollTop: ($checkoutForm.offset().top - 100)
                        }, 500);
                    }
                });
            });
        </script>
        <?php
    }
}
