// Change "Read More" text to "Out of Stock" for out-of-stock products
add_filter( 'woocommerce_product_add_to_cart_text', 'change_read_more_text_for_out_of_stock_products', 10, 2 );
function change_read_more_text_for_out_of_stock_products( $text, $product ) {
    if ( !$product->is_in_stock() ) {
        return 'No disponible'; // Change the text as needed
    }
    return $text;
}

// Remove the link of the "Add to Cart" / "Select options" / "Read More" button for out-of-stock products
add_filter( 'woocommerce_loop_add_to_cart_link', 'remove_link_on_out_of_stock_products', 10, 2 );
function remove_link_on_out_of_stock_products( $html, $product ) {
    if ( !$product->is_in_stock() ) {
        return '<button class="button" disabled>' . esc_html( $product->add_to_cart_text() ) . '</button>'; // Button is disabled and not clickable
    }
    return $html;
}
