#!/bin/bash

# Check if running as root
if [ "$EUID" -ne 0 ]; then
    echo "Please run as root"
    exit 1
fi

# Check if curl is installed
if ! command -v curl &> /dev/null; then
    echo "curl is not installed. Installing curl..."
    apt-get update
    apt-get install -y curl
fi

# Add Wazuh repository
curl -s https://packages.wazuh.com/key/GPG-KEY-WAZUH | gpg --no-default-keyring --keyring gnupg-ring:/usr/share/keyrings/wazuh.gpg --import
chmod 644 /usr/share/keyrings/wazuh.gpg

# Add repository
echo "deb [signed-by=/usr/share/keyrings/wazuh.gpg] https://packages.wazuh.com/4.x/apt/ stable main" | tee /etc/apt/sources.list.d/wazuh.list

# Update package index
apt-get update

# Install Wazuh agent
apt-get install -y wazuh-agent

# Configure Wazuh agent with multiple manager IPs
sed -i "s/MANAGER_IP/192.168.0.17,194.56.239.153/g" /var/ossec/etc/ossec.conf

# Enable and start Wazuh agent
systemctl daemon-reload
systemctl enable wazuh-agent
systemctl start wazuh-agent

# Check status
echo "Agent status:"
systemctl status wazuh-agent

# Show agent information
echo -e "\nAgent version information:"
/var/ossec/bin/wazuh-control info

echo -e "\nInstallation completed. Please check the status above to verify the connection."