/* START Display Brand above title in cart */
// Function to display child category above product title on cart page
function display_child_category_above_product_title_on_cart( $item_name, $cart_item, $cart_item_key ) {
    // We attempt to check if $cart_item contains product details
    if ( isset( $cart_item['product_id'] ) ) {
        $product_id = $cart_item['product_id'];

        // Get child categories of the product
        $product_categories = get_the_terms( $product_id, 'product_cat' );

        if ( $product_categories && ! is_wp_error( $product_categories ) ) {
            // Loop through each category
            foreach ( $product_categories as $product_category ) {
                // Check if the category is a child category
                if ( $product_category->parent !== 0 ) {
                    // Display the child category name
                    $item_name = '<div class="child-category">' . $product_category->name . '</div>' . $item_name;
                }
            }
        }
    }

    // Return the modified or original item name
    return $item_name;
}
add_filter( 'woocommerce_cart_item_name', 'display_child_category_above_product_title_on_cart', 10, 3 );
/* END Display Brand above title in cart */
