// custom QRh Feed check - not working correctly
add_action('woocommerce_product_options_inventory_product_data', 'add_google_feed_checkbox');

function add_google_feed_checkbox() {
    global $post;

    // Get the current value of the '_google_feed_include' meta key.
    $google_feed_include = get_post_meta($post->ID, '_google_feed_include', true);

    // Convert the meta value to a boolean.
    $checked = 'yes' === $google_feed_include; // This will be true if 'yes', false otherwise

    woocommerce_wp_checkbox(array(
        'id' => '_google_feed_include',
        'label' => __('Google Feed', 'text-domain'),
        'description' => __('If unchecked, this product will not show in the Google Feed.', 'text-domain'),
        'desc_tip' => true,
        'value' => 'yes', // The value to send when checked
        'checked' => $checked, // The state of the checkbox (boolean)
    ));
}

add_action('woocommerce_process_product_meta', 'save_google_feed_checkbox_value', 10, 1);

function save_google_feed_checkbox_value($post_id) {
    if (!isset($_POST['woocommerce_meta_nonce']) || !wp_verify_nonce($_POST['woocommerce_meta_nonce'], 'woocommerce_save_data')) {
        return;
    }

    $google_feed_include = isset($_POST['_google_feed_include']) && 'yes' === $_POST['_google_feed_include'] ? 'yes' : 'no';
    update_post_meta($post_id, '_google_feed_include', $google_feed_include);
}
