/* START custom add to cart button on home */
function custom_add_to_cart_button_with_icon() {
    // Remove the default add to cart button
    remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10);

    // Add the new custom button
    add_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart_with_icon', 10);
}

function woocommerce_template_loop_add_to_cart_with_icon() {
    global $product;
    echo sprintf('<a href="%s" class="button add_to_cart_button" style="display:inline-block; background-image:url(\'https://staging.qrh.app/wp-content/uploads/2024/03/XL-2.png\'); width: 48px; height: 48px; background-size: cover;"></a>', esc_url($product->add_to_cart_url()));
}

add_action('init', 'custom_add_to_cart_button_with_icon');


/* END custom add to cart button on home */
