// for QRh

function add_empty_cart_message_sitewide() {
    // Check if WooCommerce is active before proceeding
    if ( class_exists('WooCommerce') ) {
        ?>
        <script type="text/javascript">
        jQuery(document).ready(function($) {
            var cartContainer = $('.elementor-menu-cart__main'); // Ensure this targets your specific menu cart container

            // This function updates the message based on cart contents
            function updateEmptyCartMessage() {
                var cartCount = <?php echo WC()->cart->get_cart_contents_count(); ?>;
                
                if (cartCount === 0) {
                    if (cartContainer.find('.empty-cart-message').length === 0) { // Check if the message is not already there
                        cartContainer.append('<div class="empty-cart-message">No hay productos en su carrito. <a href="/tienda" class="shop-link">Haga clic aquí para ir a la tienda.</a></div>');
                    }
                } else {
                    cartContainer.find('.empty-cart-message').remove(); // Remove the message if the cart is not empty
                }
            }

            // Initial call to set the right message
            updateEmptyCartMessage();

            // Re-check when AJAX requests complete in case the cart is updated dynamically
            $(document).ajaxComplete(function() {
                updateEmptyCartMessage();
            });
        });
        </script>
        <style>
        .empty-cart-message {
            padding: 20px;
            text-align: center;
            font-size: 16px;
        }
        .shop-link {
            font-family: 'Roboto', Sans-serif;
            font-size: 16px;
            line-height: 24px;
            color: #FFFFFF;
            background-color: #21210E;
            text-decoration: none;
            padding: 10px 20px;
            display: inline-block;
            border-radius: 4px;
            transition: background-color 0.3s ease;
        }
        .shop-link:hover {
            background-color: #E50913;
        }
        </style>
        <?php
    }
}
add_action('wp_footer', 'add_empty_cart_message_sitewide');
