#!/bin/bash

# Loop through all ZIP files in the current directory
for zipfile in *.zip; do
    # Check if the file exists (in case no .zip files are found)
    [ -e "$zipfile" ] || continue
    
    # Get the filename without the .zip extension
    dirname="${zipfile%.zip}"
    
    # Create a temporary directory for extraction
    temp_dir=$(mktemp -d)
    
    # Extract the ZIP file to the temporary directory
    unzip -q "$zipfile" -d "$temp_dir"
    
    # If the extraction was successful, rename the directory
    if [ $? -eq 0 ]; then
        # Remove existing directory if it exists
        [ -d "$dirname" ] && rm -rf "$dirname"
        
        # Rename the temporary directory to the ZIP filename (without .zip)
        mv "$temp_dir" "$dirname"
        echo "Extracted and renamed: $zipfile -> $dirname"
    else
        echo "Failed to extract: $zipfile"
        # Clean up the temporary directory in case of failure
        rm -rf "$temp_dir"
    fi
done

echo "Extraction and renaming complete!"