<?php
/*
Template Name: Confirmación de Cierre de Sesión
*/

// for QRh

if (!is_user_logged_in()) {
    wp_redirect(home_url());
    exit;
}

get_header();
?>

<div class="logout-confirmation">
    <h1><?php _e('¿Está seguro de que desea cerrar sesión?', 'your-theme'); ?></h1>
    <p><?php _e('Gracias por comprar en Quick Response Hairdressing. ¡Esperamos verte pronto!', 'your-theme'); ?></p>
    <a href="<?php echo wp_logout_url(home_url()); ?>" class="logout-button"><?php _e('Sí, cerrar sesión', 'your-theme'); ?></a>
    <a href="<?php echo home_url(); ?>" class="cancel-button"><?php _e('Cancelar', 'your-theme'); ?></a>
</div>

<style>
    .logout-confirmation {
        text-align: center;
        padding: 20px;
    }
    .logout-confirmation h1 {
        font-family: "Nexa-Heavy", Sans-serif;
        font-weight: 600;
        font-size: 24px;
        line-height: 32px;
        color: #21210E;
        margin-bottom: 20px;
    }
    .logout-confirmation p {
        font-family: 'Roboto', sans-serif;
        font-size: 16px;
        line-height: 24px;
        color: #21210E;
        margin-bottom: 20px;
    }
    .logout-button, .cancel-button {
        display: inline-block;
        font-family: 'Roboto', sans-serif;
        font-size: 16px;
        line-height: 24px;
        padding: 10px 20px;
        margin: 5px;
        text-decoration: none;
        color: #ffffff;
    }
    .logout-button {
        background-color: #E50913;
    }
    .logout-button:hover {
        background-color: #21210E;
        text-decoration: underline;
        color: #ffffff;
    }
    .cancel-button {
        background-color: #21210E;
    }
    .cancel-button:hover {
        background-color: #E50913;
        text-decoration: underline;
        color: #ffffff;
    }
</style>

<?php
get_footer();
?>
