/* START  Unique product count in cart */
// Shortcode to display the number of unique products in the cart with styling
function display_unique_cart_product_count_styled() {
    // Initialize an empty array to store unique product IDs
    $unique_product_ids = array();

    // Get the cart contents
    $cart_contents = WC()->cart->get_cart();

    // Loop through each item in the cart
    foreach ($cart_contents as $cart_item) {
        // Get the product ID
        $product_id = $cart_item['product_id'];

        // Check if the product ID is not already in the array
        if (!in_array($product_id, $unique_product_ids)) {
            // If not, add it to the array
            $unique_product_ids[] = $product_id;
        }
    }

    // Count the number of unique products
    $unique_product_count = count($unique_product_ids);

    // Style the output
    $output = '<span style="color: #21201E; font-family: Nexa-Bold, sans-serif; font-size: 24px; line-height: 32px;">Tu pedido (' . $unique_product_count . ' productos)</span>';

    // Return the styled output
    return $output;
}
add_shortcode('unique_cart_product_count_styled', 'display_unique_cart_product_count_styled');

/* END Unique product count in cart */
